<?php
class yp
{
	private $db;
	private $yp_table;
	private $type_table;
	private $comment_table;
	private $news_table;
	private $product_table;
	private $photo_table;
	private $mingpian_table;

	function __construct()
	{
		global $db;
		$this->db=$db;
		$this->yp_table=LA_PRE.'yp';
		$this->type_table=LA_PRE.'yp_type';
		$this->comment_table=LA_PRE.'yp_comment';
		$this->news_table=LA_PRE.'yp_news';
		$this->product_table=LA_PRE.'yp_product';
		$this->photo_table=LA_PRE.'yp_photo';
		$this->mingpian_table=LA_PRE.'yp_mingpian';
	}

	function yplist($userid=0,$status=-1,$starttime='',$endtime='',$k='')
	{
		global $page,$_siteid,$siteidobj;
		$userid=intval($userid);
		$where=$_siteid?'siteid IN('.implode(',',$siteidobj->getchildid($_siteid)).')':'1';
		$where=$userid?' userid='.$userid:'1';
		$where.=$status>-1?' AND status='.$status:'';
		$where.=$starttime?' AND updatetime>=\''.trim($starttime).'\'':'';
		$where.=$endtime?' AND updatetime<=\''.(trim($endtime)+24*3600).'\'':'';
		$where.=$k?' AND name LIKE \'%'.$k.'%\'':'';

		include SYSTEM_ROOT.'include/datalist.class.php';
		$datalist = new datalist();
		$orderby='id DESC';
		$page=max(isset($page)?intval($page):1,1);
		$pagesize=15;
		$result=$datalist->getlist($this->yp_table,$where,$orderby,$page,$pagesize);
		$this->pagestring=$datalist->pagestring;
		return $result;
	}

	function formatypdomain($id)
	{
		global $moduleobj,$configobj,$urlcacheobj;

		$key='key-yp-domain-'.$id;
		$url=$urlcacheobj->get($key);
		
		if(!$url)
		{	
			$coninfo=$this->getyp($id);
			$sites=$configobj->getsiteconfig($coninfo['siteid']);
			$parseurl=parse_url($sites['siteurl']);
			$parseurl=explode('.',$parseurl['host']);

			if($coninfo['domain'] && (sizeof($parseurl)==2 || sizeof($parseurl)==3))
			{
				
				$url= 'http://'.$coninfo['domain'].'.cn.'.($parseurl[2]?$parseurl[1]:$parseurl[0]).'.'.($parseurl[2]?$parseurl[2]:$parseurl[1]).'/';
			}
			else
			{
				$modinfo=$moduleobj->get(16);
				$modsettings=$configobj->getconfig($_SESSION['siteid'],16);
				if(preg_match('/http:\/\/(.+)/i',$modsettings['domain']))
				{
					$url= $modsettings['domain'].'web/';
				}
				else
				{
					$url= LA_PATH.$modinfo['folder'].'/web/';
				}
			}
			$urlcacheobj->set($key,$url);
		}

		return $url;
	}

	function formatypurl($id,$is_rewrite=1,$preview=0)
	{	
		global $moduleobj,$configobj,$urlcacheobj;

		$key='key-yp-'.$id;
		$url=$urlcacheobj->get($key);
		
		if(!$url)
		{
			$coninfo=$this->getyp($id);
			$sites=$configobj->getsiteconfig($coninfo['siteid']);
			$parseurl=parse_url($sites['siteurl']);
			$parseurl=explode('.',$parseurl['host']);

			if($coninfo['domain'] && (sizeof($parseurl)==2 || sizeof($parseurl)==3))
			{
				
				$url= 'http://'.$coninfo['domain'].'.cn.'.($parseurl[2]?$parseurl[1]:$parseurl[0]).'.'.($parseurl[2]?$parseurl[2]:$parseurl[1]).'/';
			}
			else
			{
				$modinfo=$moduleobj->get(16);
				$modsettings=$configobj->getconfig($_SESSION['siteid'],16);
				
				if(preg_match('/http:\/\/(.+)/i',$modsettings['domain']))
				{
					if($modsettings['is_rewrite'] && $is_rewrite)
					{
						$url= $modsettings['domain'].'web/index-'.intval($id).'.html';
					}
					else
					{
						$url= $modsettings['domain'].'web/index.php?mod='.$modinfo['folder'].'&action=index&id='.intval($id).($preview?'&preview=1':'');
					}
				}
				else
				{
					if($modsettings['is_rewrite'] && $is_rewrite)
					{
						$url= LA_PATH.$modinfo['folder'].'/web/index-'.intval($id).'.html';
					}
					else
					{
						$url= LA_PATH.$modinfo['folder'].'/web/index.php?mod='.$modinfo['folder'].'&action=index&id='.intval($id).($preview?'&preview=1':'');
					}
				}
			}
			$urlcacheobj->set($key,$url);
		}

		return $url;
	}

	function getyp($id)
	{	
		$id=intval($id);
		return $this->db->fetch_one("SELECT * FROM `$this->yp_table` WHERE `$this->yp_table`.`id`=$id");
	}

	function ypclicks($id)
	{
		$id=intval($id);
		return $this->db->query("UPDATE `$this->yp_table` SET `$this->yp_table`.`clicks`=`$this->yp_table`.`clicks`+1 WHERE `$this->yp_table`.`id`=$id");
	}

	function getypbyuserid($id)
	{	
		$id=intval($id);
		return $this->db->fetch_one("SELECT * FROM `$this->yp_table` WHERE `$this->yp_table`.`userid`=$id");
	}

	function getypbydomain($domain)
	{	
		$domain=preg_replace('/[^a-z0-9_]/i','',strtolower($domain));
		return $this->db->fetch_one("SELECT * FROM `$this->yp_table` WHERE `$this->yp_table`.`domain`='$domain'");
	}

	function isdomainexists($domain='')
	{
		$domain=preg_replace('/[^a-z0-9_]/i','',$domain);
		return $this->db->fetch_one("SELECT * FROM `$this->yp_table` WHERE `$this->yp_table`.`domain`='$domain'");
	}

	function member_yp_edit($info,$modelid=0,$extend=0,$userid=0)
	{
		global $modelobj,$settings,$dataobj,$cacheobj;
		$modelid=intval($modelid);
		$extend=intval($extend);
		$userid=intval($userid);
		
		$modelinfo=$modelobj->info($modelid);

		$dataobj->setmodel(array(intval($modelid),intval($extend)));
		$info=$dataobj->filter($info);
		$info['modelid']=$modelid;
		$info['moduleid']=16;
		$info['updatetime']=TIME;
		$info['ip']=IP;
		$info['userid']=$userid;
		$info['siteid']=intval($_SESSION['siteid']);
		unset($info['istop']);
		$hash_table=get_hash_table(LA_PRE.$modelinfo['tbname'].'_data',$id,$modelobj->subformcount(intval($extend)));
		$coninfo=$this->getypbyuserid($userid);
		if($coninfo)
		{
			$this->db->update($this->yp_table,$info,'userid='.$userid);
			$this->db->update($hash_table,$info,'mid='.$coninfo['id']);
		}
		else
		{
			$info['mid']=$this->db->insert($this->yp_table,$info);
			$this->db->insert($hash_table,$info);
		}
		
		$cacheobj->clear();
		return true;
	}

	function ypstatis($moduleid=7,$status=-1)
	{
		global $siteidobj,$_siteid;
		$moduleid=intval($moduleid);
		$status=intval($status);

		$where=$_siteid?' siteid IN('.implode(',',$siteidobj->getchildid($_siteid)).')':'1';
		$where.=$status>=0?' AND status='.$status:'';
		$where.=$moduleid?' AND moduleid='.$moduleid:'';

		return get_cache_counts("SELECT COUNT(*) AS count FROM `$this->yp_table` WHERE $where");
	}

	function ypset($info,$ids=array())
	{
		global $settings,$_siteid,$siteidobj,$modelobj;

		$ids=is_array($ids)?array_map('intval',$ids):array(intval($ids));
		foreach($ids as $id)
		{
			if($id)
			{
				$cinfo=$this->getyp($id);
				if(!$cinfo || ($_siteid && !in_array($cinfo['siteid'],$siteidobj->getchildid($_siteid))))
				{
					return false;
				}
				else
				{
					$hash_table=get_hash_table($this->yp_table.'_data',$id,$modelobj->subformcount2($cinfo['modelid']));
					$this->db->update($this->yp_table,$info,'id='.$id);
					$this->db->update($hash_table,$info,'mid='.$id);
				}
			}
		}
		return true;
	}

	function ypsettemplate($temp,$ids=array())
	{
		$ids=is_array($ids)?array_map('intval',$ids):array(intval($ids));
		foreach($ids as $id)
		{
			if($id)
			{
				$this->db->update($this->yp_table,array('template'=>$temp[$id]),'id='.$id);
			}
		}
		return true;
	}

	function yp_delete($ids=array(),$userid)
	{
		global $settings,$_siteid,$siteidobj,$modelobj;

		$ids=is_array($ids)?array_map('intval',$ids):array(intval($ids));
		foreach($ids as $id)
		{
			if($id)
			{
				$cinfo=$this->getyp($id);
				if(!$cinfo || ($_siteid && !in_array($cinfo['siteid'],$siteidobj->getchildid($_siteid))))
				{
					return false;
				}
				else
				{
					$hash_table=get_hash_table($this->yp_table.'_data',$id,$modelobj->subformcount2($cinfo['modelid']));
					$this->db->mysql_delete($this->yp_table,$id);
					$this->db->mysql_delete($hash_table,$id,'mid');
				}
			}
		}
		return true;
	}

	function admin_yp_add($info,$modelid=0,$extend=0)
	{
		global $modelobj,$settings,$dataobj,$cacheobj,$memberobj;
		$info['modelid']=intval($modelid);
		$modelinfo=$modelobj->info($modelid);
	
		$dataobj->setmodel(array(intval($modelid),intval($extend)));
		$info=$dataobj->filter($info);

		$mem=$info;
		$mem['gradeid']=3;
		$mem['username']='company_'.TIME;
		$mem['password']=md5(mt_rand(100000,999999));
		$mem['email']='company_'.TIME.'@topmps.com';
		$mem['company']=$info['name'];
		$info['userid']=$memberobj->admin_companyadd($mem);

		$info['updatetime']=TIME;
		$info['ip']=IP;
		$info['status']=1;
		$info['siteid']=intval($_SESSION['siteid']);
		$info['mid']=$this->db->insert(LA_PRE.$modelinfo['tbname'],$info,true);
		$hash_table=get_hash_table(LA_PRE.$modelinfo['tbname'].'_data',$info['mid'],$modelobj->subformcount(intval($extend)));
		$cacheobj->clear();
		return $this->db->insert($hash_table,$info,true);
	}

	function admin_yp_edit($info,$id,$modelid=0,$extend=0)
	{
		global $modelobj,$settings,$dataobj,$cacheobj;
		$modelid=intval($modelid);
		$extend=intval($extend);
		$id=intval($id);
		
		$modelinfo=$modelobj->info($modelid);

		$dataobj->setmodel(array(intval($modelid),intval($extend)));
		$info=$dataobj->filter($info);
		$info['updatetime']=TIME;

		$info['siteid']=intval($_SESSION['siteid']);
		$this->db->update($this->yp_table,$info,'id='.$id);
		$hash_table=get_hash_table(LA_PRE.$modelinfo['tbname'].'_data',$id,$modelobj->subformcount(intval($extend)));
		$cacheobj->clear();
		return $this->db->update($hash_table,$info,'mid='.$id);
	}
	
	function typelist($typeid=0)
	{
		global $page,$_siteid,$siteidobj;
		$typeid=intval($typeid);

		$where=$_siteid?'siteid IN('.implode(',',$siteidobj->getchildid($_siteid)).')':1;
		$where.=$typeid?' AND parentid='.$typeid:' AND parentid=0';

		include SYSTEM_ROOT.'include/datalist.class.php';
		$datalist = new datalist();
		$orderby='orderby ASC ,typeid ASC';
		$page=max(isset($page)?intval($page):1,1);
		$pagesize=25;
		$result=$datalist->getlist($this->type_table,$where,$orderby,$page,$pagesize);
		$this->pagestring=$datalist->pagestring;
		return $result;
	}

	function tlptypelist($typeid=0)
	{
		$typeid=intval($typeid);
		return $this->db->fetch_all("SELECT * FROM `$this->type_table` WHERE `$this->type_table`.`parentid`=$typeid ORDER BY `$this->type_table`.`orderby` ASC");
	}

	function type_add($info)
	{
		$info['grandparentid']=$info['parentid']?$this->typeparentid($info['parentid']):0;
		$info['siteid']=intval($_SESSION['siteid']);
		return $this->db->insert($this->type_table,$info);
	}

	function typesqlids($id)
	{
		$id=intval($id);
		$arr=array($id);
		$i=1;
		$r=$this->db->fetch_all("SELECT * FROM `$this->type_table` WHERE  `$this->type_table`.`parentid`=$id");

		if($r)foreach($r as $_r)
		{
			$arr[$i]=$_r['typeid'];
			$i++;
		}

		return $arr;
	}

	function type_delete($id)
	{
		global $_siteid,$siteidobj;
		$id=intval($id);
		$minfo=$this->typeinfo($id);
		if(!$minfo || ($_siteid && !in_array($minfo['siteid'],$siteidobj->getchildid($_siteid))))
		{
			return false;
		}

		$this->db->mysql_delete($this->type_table,intval($id),'typeid');
		$this->db->mysql_delete($this->type_table,intval($id),'parentid');
		$this->db->mysql_delete($this->type_table,intval($id),'grandparentid');
		return true;
	}

	function gettypeid($moduleid=7)
	{
		$r=$this->db->fetch_one("SELECT * FROM `$this->type_table` WHERE `$this->type_table`.`moduleid`=".intval($moduleid)." ORDER BY `$this->type_table`.`typeid` ASC");
		return $r?$r['typeid']:0;
	}

	function type_edit($info,$id)
	{
		global $_siteid,$siteidobj;
		$id=intval($id);
		$minfo=$this->typeinfo($id);
		if(!$minfo || ($_siteid && !in_array($minfo['siteid'],$siteidobj->getchildid($_siteid))))
		{
			return false;
		}
		$info['grandparentid']=$info['parentid']?$this->typeparentid($info['parentid']):0;
		return $this->db->update($this->type_table,$info,'typeid='.intval($id));
	}

	function typeinfo($id)
	{
		return $this->db->fetch_one("SELECT * FROM `$this->type_table` WHERE `$this->type_table`.`typeid`=".intval($id));
	}

	function typename($id)
	{
		$r=$this->typeinfo($id);
		return $r['name'];
	}

	function typeurl($id,$is_rewrite=1,$preview=0)
	{	
		global $moduleobj,$configobj,$urlcacheobj;

		$key='key-yptypeurl-'.$id;
		$url=$urlcacheobj->get($key);
		
		if(!$url)
		{
			$modinfo=$moduleobj->get(16);
			$modsettings=$configobj->getconfig($_SESSION['siteid'],16);
			
			if(preg_match('/http:\/\/(.+)/i',$modsettings['domain']))
			{
				if($modsettings['is_rewrite'] && $is_rewrite)
				{
					$url= $modsettings['domain'].'list-'.intval($id).'.html';
				}
				else
				{
					$url= $modsettings['domain'].'index.php?mod='.$modinfo['folder'].'&action=list&id='.intval($id).($preview?'&preview=1':'');
				}
			}
			else
			{
				if($modsettings['is_rewrite'] && $is_rewrite)
				{
					$url= LA_PATH.$modinfo['folder'].'/list-'.intval($id).'.html';
				}
				else
				{
					$url= LA_PATH.$modinfo['folder'].'/index.php?mod='.$modinfo['folder'].'&action=list&id='.intval($id).($preview?'&preview=1':'');
				}
			}
			$urlcacheobj->set($key,$url);
		}

		return $url;
		
	}

	function parenttypename($id)
	{
		$pid=$this->typeparentid($id);
		$r=$pid?$this->typeinfo($pid):array('name'=>'');
		return $r['name'];
	}

	function typeparentid($id)
	{
		$r=$this->typeinfo($id);
		return $r['parentid'];
	}

	function type_select($parentid=0,$g=3)
	{
		$str='';
		$r=$this->db->fetch_all("SELECT * FROM `$this->type_table` WHERE `$this->type_table`.`parentid`=".intval($parentid)." ORDER BY `$this->type_table`.`orderby` ASC,`$this->type_table`.`typeid` ASC");
		foreach($r as $_r)
		{
			if($g>=2)
			{
				$r2=$this->db->fetch_all("SELECT * FROM `$this->type_table` WHERE `$this->type_table`.`parentid`=".intval($_r['typeid'])." ORDER BY `$this->type_table`.`orderby` ASC,`$this->type_table`.`typeid` ASC");
				if($r2)
				{
					$str.='<optgroup label="'.$_r['name'].'">';
					foreach($r2 as $_r2)
					{
						if($g>=3)
						{
							$r3=$this->db->fetch_all("SELECT * FROM `$this->type_table` WHERE `$this->type_table`.`parentid`=".intval($_r2['typeid'])." ORDER BY `$this->type_table`.`orderby` ASC,`$this->type_table`.`typeid` ASC");
							if($r3)
							{
								$str.='<option value="'.$_r2['typeid'].'" disabled="disabled">'.$_r2['name'].'</option>';
								foreach($r3 as $_r3)
								{
									$str.='<option value="'.$_r3['typeid'].'">|--'.$_r3['name'].'</option>';
								}
							}
							else
							{
								$str.='<option value="'.$_r2['typeid'].'">'.$_r2['name'].'</option>';
							}
						}
						else
						{
							$str.='<option value="'.$_r2['typeid'].'">'.$_r2['name'].'</option>';
						}
					}
					$str.='</optgroup>';
				}
				else
				{
					$str.='<option value="'.$_r['typeid'].'">'.$_r['name'].'</option>';
				}
			}
			else
			{
				$str.='<option value="'.$_r['typeid'].'">'.$_r['name'].'</option>';
			}
		}

		return $str;
	}

	function type_select_cat($parentid=0)
	{
		$str='';
		$r=$this->db->fetch_all("SELECT * FROM `$this->type_table` WHERE `$this->type_table`.`parentid`=".intval($parentid)." ORDER BY `$this->type_table`.`orderby` ASC,`$this->type_table`.`typeid` ASC");
		foreach($r as $_r)
		{
			$r2=$this->db->fetch_all("SELECT * FROM `$this->type_table` WHERE  `$this->type_table`.`parentid`=".intval($_r['typeid'])." ORDER BY `$this->type_table`.`orderby` ASC,`$this->type_table`.`typeid` ASC");
			if($r2)
			{
				$str.='<option value="'.$_r['typeid'].'">'.$_r['name'].'</option>';
				foreach($r2 as $_r2)
				{
					$str.='<option value="'.$_r2['typeid'].'">|--'.$_r2['name'].'</option>';
				}
				$str.='</option>';
			}
			else
			{
				$str.='<option value="'.$_r['typeid'].'">'.$_r['name'].'</option>';
			}
		}

		return $str;
	}

	function ypcommentlist($ypid=0,$status=-1,$starttime='',$endtime='',$k='')
	{
		global $page,$_siteid,$siteidobj;
		$ypid=intval($ypid);
		$where=$_siteid?'siteid IN('.implode(',',$siteidobj->getchildid($_siteid)).')':'1';
		$where.=$ypid?' AND ypid='.$ypid:'';
		$where.=$status>-1?' AND status='.$status:'';
		$where.=$starttime?' AND inputtime>=\''.trim($starttime).'\'':'';
		$where.=$endtime?' AND inputtime<=\''.(trim($endtime)+24*3600).'\'':'';
		$where.=$k?' AND content LIKE \'%'.$k.'%\'':'';

		include SYSTEM_ROOT.'include/datalist.class.php';
		$datalist = new datalist();
		$orderby='id DESC';
		$page=max(isset($page)?intval($page):1,1);
		$pagesize=15;
		$result=$datalist->getlist($this->comment_table,$where,$orderby,$page,$pagesize);
		$this->pagestring=$datalist->pagestring;
		return $result;
	}

	function member_ypcommentlist($userid=0,$status=-1,$starttime='',$endtime='',$k='')
	{
		global $page,$_siteid,$siteidobj;
		$userid=intval($userid);
		$where=$_siteid?'siteid IN('.implode(',',$siteidobj->getchildid($_siteid)).')':'1';
		$where.=$userid?' AND ypuserid='.$userid:'';
		$where.=$status>-1?' AND status='.$status:'';
		$where.=$starttime?' AND inputtime>=\''.trim($starttime).'\'':'';
		$where.=$endtime?' AND inputtime<=\''.(trim($endtime)+24*3600).'\'':'';
		$where.=$k?' AND content LIKE \'%'.$k.'%\'':'';

		include SYSTEM_ROOT.'include/datalist.class.php';
		$datalist = new datalist();
		$orderby='id DESC';
		$page=max(isset($page)?intval($page):1,1);
		$pagesize=15;
		$result=$datalist->getlist($this->comment_table,$where,$orderby,$page,$pagesize);
		$this->pagestring=$datalist->pagestring;
		return $result;
	}

	function usercomment($id,$haoping,$fuwu,$huanjing,$xingjiabi,$content,$renjun)
	{
		global $settings,$_gradeid,$_userid;
		$r=$this->getyp($id);
		
		if(!$r)
		{
			return false;
		}
		$info=array();
		$info['xihuan']=$haoping;
		$info['fuwu']=$fuwu;
		$info['huanjing']=$huanjing;
		$info['xingjiabi']=$xingjiabi;
		$info['content']=$content;
		$info['renjun']=$renjun;
		$info['inputtime']=TIME;
		$info['ypid']=$id;
		$info['comuserid']=$_userid;
		$info['ypuserid']=$r['userid'];
		$info['siteid']=intval($_SESSION['siteid']);
		$info['status']=in_array($_gradeid,explode(',',$settings['commentpass_membergrade']))?1:0;

		$this->db->insert($this->comment_table,$info);
		$c=$this->db->fetch_all("SELECT * FROM `$this->comment_table` WHERE `$this->comment_table`.`ypid`=$id");
		
		$m=array();

		foreach($c as $_c)
		{
			$p_haoping+=floatval($_c['xihuan']);
			$p_fuwu+=floatval($_c['fuwu']);
			$p_huanjing+=floatval($_c['huanjing']);
			$p_xingjiabi+=floatval($_c['xingjiabi']);
			$p_renjun+=floatval($_c['renjun']);
		}

		$m['haoping']=(round($p_haoping/sizeof($c),1)*100).'%';
		$m['fuwu']=intval($p_fuwu/sizeof($c));
		$m['huanjing']=intval($p_huanjing/sizeof($c));
		$m['xingjiabi']=intval($p_xingjiabi/sizeof($c));
		$m['renjun']=round($p_renjun/sizeof($c),2);

		return $this->db->update($this->yp_table,$m,'id='.$id);
	}

	function commentinfo($commentid)
	{	
		$commentid=intval($commentid);
		return $this->db->fetch_one("SELECT * FROM `$this->comment_table` WHERE `$this->comment_table`.`id`=$commentid");
	}

	function comment_set($info,$ids=array())
	{
		global $settings,$_siteid,$siteidobj;

		$ids=is_array($ids)?array_map('intval',$ids):array(intval($ids));
		foreach($ids as $id)
		{
			if($id)
			{
				$cinfo=$this->commentinfo($id);
				if(!$cinfo || ($_siteid && !in_array($cinfo['siteid'],$siteidobj->getchildid($_siteid))))
				{
					return false;
				}
				else
				{
					$this->db->update($this->comment_table,$info,'id='.$id);
				}
			}
		}
		return true;
	}

	function comment_reply($reply,$id)
	{
		$id=intval($id);
		$cinfo=$this->commentinfo($id);
		if(!$cinfo || ($_siteid && !in_array($cinfo['siteid'],$siteidobj->getchildid($_siteid))))
		{
			return false;
		}
		else
		{
			if(!$userid || $userid==$cinfo['ypuserid'])
			{
				return $this->db->update($this->comment_table,array('reply'=>strip_tags($reply)),'id='.intval($id));
			}
		}

		return false;
	}

	function comment_delete($ids=array(),$userid=0)
	{
		global $settings,$_siteid,$siteidobj;

		$ids=is_array($ids)?array_map('intval',$ids):array(intval($ids));
		foreach($ids as $id)
		{
			if($id)
			{
				$cinfo=$this->commentinfo($id);
				if(!$cinfo || ($_siteid && !in_array($cinfo['siteid'],$siteidobj->getchildid($_siteid))))
				{
					return false;
				}
				else
				{
					$coninfo=$this->getyp($cinfo['ypid']);
					if(!$userid || $userid==$coninfo['userid'])
					{
						$this->db->mysql_delete($this->comment_table,$id,'id');
					}
				}
			}
		}

		return true;
	}

	function commentstatis($ypid=0,$status=-1,$userid=0)
	{
		global $siteidobj,$_siteid;
		$ypid=intval($ypid);
		$status=intval($status);
		$userid=intval($userid);

		$where='1';
		$where.=$_siteid?' AND siteid IN('.implode(',',$siteidobj->getchildid($_siteid)).')':'';
		$where.=$status>=0?' AND status='.$status:'';
		$where.=$userid?' AND userid='.$userid:'';
		$where.=$ypid?' AND ypid='.$ypid:'';
		return get_cache_counts("SELECT COUNT(*) AS count FROM `$this->comment_table` WHERE $where");
	}

	function typestatis($typeid=0)
	{
		global $siteidobj,$_siteid;
		$typeid=intval($typeid);

		$where='1';
		$where.=$_siteid?' AND siteid IN('.implode(',',$siteidobj->getchildid($_siteid)).')':'';
		$where.=$typeid?' AND typeid='.$typeid:'';
		return get_cache_counts("SELECT COUNT(*) AS count FROM `$this->yp_table` WHERE $where");
	}

	function ypnewslist($ypid=0,$status=-1,$starttime='',$endtime='',$k='')
	{
		global $page,$_siteid,$siteidobj;
		$ypid=intval($ypid);
		$where=$_siteid?'siteid IN('.implode(',',$siteidobj->getchildid($_siteid)).')':'1';
		$where.=$ypid?' AND ypid='.$ypid:'';
		$where.=$status>-1?' AND status='.$status:'';
		$where.=$starttime?' AND inputtime>=\''.trim($starttime).'\'':'';
		$where.=$endtime?' AND inputtime<=\''.(trim($endtime)+24*3600).'\'':'';
		$where.=$k?' AND title LIKE \'%'.$k.'%\'':'';

		include SYSTEM_ROOT.'include/datalist.class.php';
		$datalist = new datalist();
		$orderby='id DESC';
		$page=max(isset($page)?intval($page):1,1);
		$pagesize=15;
		$result=$datalist->getlist($this->news_table,$where,$orderby,$page,$pagesize);
		$this->pagestring=$datalist->pagestring;
		return $result;
	}

	function member_ypnewslist($userid=0,$status=-1,$starttime='',$endtime='',$k='')
	{
		global $page,$_siteid,$siteidobj;
		$userid=intval($userid);
		$where=$_siteid?'siteid IN('.implode(',',$siteidobj->getchildid($_siteid)).')':'1';
		$where.=$userid?' AND ypuserid='.$userid:'';
		$where.=$status>-1?' AND status='.$status:'';
		$where.=$starttime?' AND inputtime>=\''.trim($starttime).'\'':'';
		$where.=$endtime?' AND inputtime<=\''.(trim($endtime)+24*3600).'\'':'';
		$where.=$k?' AND title LIKE \'%'.$k.'%\'':'';

		include SYSTEM_ROOT.'include/datalist.class.php';
		$datalist = new datalist();
		$orderby='inputtime DESC';
		$page=max(isset($page)?intval($page):1,1);
		$pagesize=15;
		$result=$datalist->getlist($this->news_table,$where,$orderby,$page,$pagesize);
		$this->pagestring=$datalist->pagestring;
		return $result;
	}


	function news_setdelete($id,$userid)
	{
		$id=intval($id);
		$userid=intval($userid);
		return $this->db->query("DELETE FROM `$this->news_table` WHERE `$this->news_table`.`id`=$id AND  `$this->news_table`.`ypuserid`=$userid");
	}

	function news_refresh($id,$userid,$moduleid)
	{
		global $settings,$_gradeid,$_point,$_amount,$memberobj;

		$id=intval($id);
		$userid=intval($userid);
		$moduleid=intval($moduleid);
		
		return $this->db->query("UPDATE `$this->news_table` SET `$this->news_table`.`inputtime`=".TIME." WHERE `$this->news_table`.`id`=$id AND  `$this->news_table`.`ypuserid`=$userid");
	}

	function newsinfo($newsid)
	{	
		$newsid=intval($newsid);
		return $this->db->fetch_one("SELECT * FROM `$this->news_table` WHERE `$this->news_table`.`id`=$newsid");
	}

	function member_news_add($info,$modelid=0,$extend=0)
	{
		global $modelobj,$settings,$dataobj,$cacheobj,$_userid,$_gradeid,$_point,$_amount,$conobj,$memberobj;
		$info['modelid']=intval($modelid);
		$modelinfo=$modelobj->info($modelid);

		$dataobj->setmodel(array(intval($modelid),intval($extend)));
		$info=$dataobj->filter($info);
		
		$info['clicks']=1;
		$info['siteid']=intval($_SESSION['siteid']);

		$hash_table=get_hash_table(LA_PRE.$modelinfo['tbname'].'_data',$info['mid'],$modelobj->subformcount(intval($extend)));
		
		$info['mid']=$this->db->insert(LA_PRE.$modelinfo['tbname'],$info,true);
		$this->db->insert($hash_table,$info,true);
		
		$cacheobj->clear();
		return true;
	}

	function member_news_edit($info,$modelid=0,$extend=0,$id)
	{
		global $modelobj,$settings,$dataobj,$cacheobj,$_userid,$_gradeid,$_point,$_amount,$conobj,$memberobj;
		$info['modelid']=intval($modelid);
		$id=intval($id);
		$modelinfo=$modelobj->info($modelid);

		$dataobj->setmodel(array(intval($modelid),intval($extend)));
		$info=$dataobj->filter($info);
		
		$info['inputtime']=TIME;

		$hash_table=get_hash_table(LA_PRE.$modelinfo['tbname'].'_data',$info['mid'],$modelobj->subformcount(intval($extend)));

		
		$this->db->update(LA_PRE.$modelinfo['tbname'],$info,'id='.$id);
		$this->db->update($hash_table,$info,'mid='.$id);
		
		$cacheobj->clear();
		return true;
	}

	function news_set($info,$ids=array())
	{
		global $settings,$_siteid,$siteidobj;

		$ids=is_array($ids)?array_map('intval',$ids):array(intval($ids));
		foreach($ids as $id)
		{
			if($id)
			{
				$cinfo=$this->newsinfo($id);
				if(!$cinfo || ($_siteid && !in_array($cinfo['siteid'],$siteidobj->getchildid($_siteid))))
				{
					return false;
				}
				else
				{
					$this->db->update($this->news_table,$info,'id='.$id);
				}
			}
		}
		return true;
	}

	function news_delete($ids=array(),$userid=0)
	{
		global $settings,$_siteid,$siteidobj;

		$ids=is_array($ids)?array_map('intval',$ids):array(intval($ids));
		foreach($ids as $id)
		{
			if($id)
			{
				$cinfo=$this->newsinfo($id);
				if(!$cinfo || ($_siteid && !in_array($cinfo['siteid'],$siteidobj->getchildid($_siteid))))
				{
					return false;
				}
				else
				{
					$coninfo=$this->getyp($cinfo['ypid']);
					if(!$userid || $userid==$coninfo['userid'])
					{
						$this->db->mysql_delete($this->news_table,$id,'id');
					}
				}
			}
		}

		return true;
	}

	function newsstatis($ypid=0,$status=-1,$userid=0)
	{
		global $siteidobj,$_siteid;
		$ypid=intval($ypid);
		$status=intval($status);
		$userid=intval($userid);

		$where='1';
		$where.=$_siteid?' AND siteid IN('.implode(',',$siteidobj->getchildid($_siteid)).')':'';
		$where.=$status>=0?' AND status='.$status:'';
		$where.=$userid?' AND userid='.$userid:'';
		return get_cache_counts("SELECT COUNT(*) AS count FROM `$this->news_table` WHERE $where");
	}
	
	function formatypnewsurl($id,$is_rewrite=1,$preview=0)
	{	
		global $moduleobj,$configobj,$urlcacheobj;

		$key='key-ypnews-'.$id;
		$url=$urlcacheobj->get($key);
		
		if(!$url)
		{
			$id=intval($id);
			$modinfo=$moduleobj->get(16);
			$modsettings=$configobj->getconfig($_SESSION['siteid'],16);
			
			$minfo=$this->newsinfo($id);
			
			$domain=$this->formatypdomain($minfo['ypid']);
			$url= $domain.'index.php?mod='.$modinfo['folder'].'&action=shownews&newsid='.intval($id).($preview?'&preview=1':'');
			$urlcacheobj->set($key,$url);
		}

		return $url;
		
	}
	
	function ypphotolist($ypid=0,$status=-1,$starttime='',$endtime='',$k='')
	{
		global $page,$_siteid,$siteidobj;
		$ypid=intval($ypid);
		$where=$_siteid?'siteid IN('.implode(',',$siteidobj->getchildid($_siteid)).')':'1';
		$where.=$ypid?' AND ypid='.$ypid:'';
		$where.=$status>-1?' AND status='.$status:'';
		$where.=$starttime?' AND inputtime>=\''.trim($starttime).'\'':'';
		$where.=$endtime?' AND inputtime<=\''.(trim($endtime)+24*3600).'\'':'';
		$where.=$k?' AND title LIKE \'%'.$k.'%\'':'';

		include SYSTEM_ROOT.'include/datalist.class.php';
		$datalist = new datalist();
		$orderby='id DESC';
		$page=max(isset($page)?intval($page):1,1);
		$pagesize=15;
		$result=$datalist->getlist($this->photo_table,$where,$orderby,$page,$pagesize);
		$this->pagestring=$datalist->pagestring;
		return $result;
	}

	function member_ypphotolist($userid=0,$status=-1,$starttime='',$endtime='',$k='')
	{
		global $page,$_siteid,$siteidobj;
		$userid=intval($userid);
		$where=$_siteid?'siteid IN('.implode(',',$siteidobj->getchildid($_siteid)).')':'1';
		$where.=$userid?' AND ypuserid='.$userid:'';
		$where.=$status>-1?' AND status='.$status:'';
		$where.=$starttime?' AND inputtime>=\''.trim($starttime).'\'':'';
		$where.=$endtime?' AND inputtime<=\''.(trim($endtime)+24*3600).'\'':'';
		$where.=$k?' AND title LIKE \'%'.$k.'%\'':'';

		include SYSTEM_ROOT.'include/datalist.class.php';
		$datalist = new datalist();
		$orderby='inputtime DESC';
		$page=max(isset($page)?intval($page):1,1);
		$pagesize=15;
		$result=$datalist->getlist($this->photo_table,$where,$orderby,$page,$pagesize);
		$this->pagestring=$datalist->pagestring;
		return $result;
	}


	function photo_setdelete($id,$userid)
	{
		$id=intval($id);
		$userid=intval($userid);
		return $this->db->query("DELETE FROM `$this->photo_table` WHERE `$this->photo_table`.`id`=$id AND  `$this->photo_table`.`ypuserid`=$userid");
	}

	function photo_refresh($id,$userid,$moduleid)
	{
		global $settings,$_gradeid,$_point,$_amount,$memberobj;

		$id=intval($id);
		$userid=intval($userid);
		$moduleid=intval($moduleid);
		
		return $this->db->query("UPDATE `$this->photo_table` SET `$this->photo_table`.`inputtime`=".TIME." WHERE `$this->photo_table`.`id`=$id AND  `$this->photo_table`.`ypuserid`=$userid");
	}

	function photoinfo($photoid)
	{	
		$photoid=intval($photoid);
		return $this->db->fetch_one("SELECT * FROM `$this->photo_table` WHERE `$this->photo_table`.`id`=$photoid");
	}

	function member_photo_add($info,$modelid=0,$extend=0)
	{
		global $modelobj,$settings,$dataobj,$cacheobj,$_userid,$_gradeid,$_point,$_amount,$conobj,$memberobj;
		$info['modelid']=intval($modelid);
		$modelinfo=$modelobj->info($modelid);

		$dataobj->setmodel(array(intval($modelid),intval($extend)));
		$info=$dataobj->filter($info);
		
		$info['clicks']=1;
		$info['siteid']=intval($_SESSION['siteid']);

		$hash_table=get_hash_table(LA_PRE.$modelinfo['tbname'].'_data',$info['mid'],$modelobj->subformcount(intval($extend)));

		$info['mid']=$this->db->insert(LA_PRE.$modelinfo['tbname'],$info,true);
		$this->db->insert($hash_table,$info,true);
		
		$cacheobj->clear();
		return true;
	}

	function member_photo_edit($info,$modelid=0,$extend=0,$id)
	{
		global $modelobj,$settings,$dataobj,$cacheobj,$_userid,$_gradeid,$_point,$_amount,$conobj,$memberobj;
		$info['modelid']=intval($modelid);
		$id=intval($id);
		$modelinfo=$modelobj->info($modelid);

		$dataobj->setmodel(array(intval($modelid),intval($extend)));
		$info=$dataobj->filter($info);
		
		$info['inputtime']=TIME;

		$hash_table=get_hash_table(LA_PRE.$modelinfo['tbname'].'_data',$info['mid'],$modelobj->subformcount(intval($extend)));

		
		$this->db->update(LA_PRE.$modelinfo['tbname'],$info,'id='.$id);
		$this->db->update($hash_table,$info,'mid='.$id);
		
		$cacheobj->clear();
		return true;
	}

	function photo_set($info,$ids=array())
	{
		global $settings,$_siteid,$siteidobj;

		$ids=is_array($ids)?array_map('intval',$ids):array(intval($ids));
		foreach($ids as $id)
		{
			if($id)
			{
				$cinfo=$this->photoinfo($id);
				if(!$cinfo || ($_siteid && !in_array($cinfo['siteid'],$siteidobj->getchildid($_siteid))))
				{
					return false;
				}
				else
				{
					$this->db->update($this->photo_table,$info,'id='.$id);
				}
			}
		}
		return true;
	}

	function photo_delete($ids=array(),$userid=0)
	{
		global $settings,$_siteid,$siteidobj;

		$ids=is_array($ids)?array_map('intval',$ids):array(intval($ids));
		foreach($ids as $id)
		{
			if($id)
			{
				$cinfo=$this->photoinfo($id);
				if(!$cinfo || ($_siteid && !in_array($cinfo['siteid'],$siteidobj->getchildid($_siteid))))
				{
					return false;
				}
				else
				{
					$coninfo=$this->getyp($cinfo['ypid']);
					if(!$userid || $userid==$coninfo['userid'])
					{
						$this->db->mysql_delete($this->photo_table,$id,'id');
					}
				}
			}
		}

		return true;
	}

	function photostatis($ypid=0,$status=-1,$userid=0)
	{
		global $siteidobj,$_siteid;
		$ypid=intval($ypid);
		$status=intval($status);
		$userid=intval($userid);

		$where='1';
		$where.=$_siteid?' AND siteid IN('.implode(',',$siteidobj->getchildid($_siteid)).')':'';
		$where.=$status>=0?' AND status='.$status:'';
		$where.=$userid?' AND userid='.$userid:'';
		return get_cache_counts("SELECT COUNT(*) AS count FROM `$this->photo_table` WHERE $where");
	}
	
	function formatypphotourl($id,$is_rewrite=1,$preview=0)
	{	
		global $moduleobj,$configobj,$urlcacheobj;

		$key='key-ypphoto-'.$id;
		$url=$urlcacheobj->get($key);
		
		if(!$url)
		{
			$id=intval($id);
			$modinfo=$moduleobj->get(16);
			$modsettings=$configobj->getconfig($_SESSION['siteid'],16);
			
			$minfo=$this->photoinfo($id);
			
			$domain=$this->formatypdomain($minfo['ypid']);
			
			$url= $domain.'index.php?mod='.$modinfo['folder'].'&action=showphoto&photoid='.intval($id).($preview?'&preview=1':'');
			$urlcacheobj->set($key,$url);
		}

		return $url;
		
	}
	
	function ypproductlist($ypid=0,$status=-1,$starttime='',$endtime='',$k='')
	{
		global $page,$_siteid,$siteidobj;
		$ypid=intval($ypid);
		$where=$_siteid?'siteid IN('.implode(',',$siteidobj->getchildid($_siteid)).')':'1';
		$where.=$ypid?' AND ypid='.$ypid:'';
		$where.=$status>-1?' AND status='.$status:'';
		$where.=$starttime?' AND inputtime>=\''.trim($starttime).'\'':'';
		$where.=$endtime?' AND inputtime<=\''.(trim($endtime)+24*3600).'\'':'';
		$where.=$k?' AND title LIKE \'%'.$k.'%\'':'';

		include SYSTEM_ROOT.'include/datalist.class.php';
		$datalist = new datalist();
		$orderby='id DESC';
		$page=max(isset($page)?intval($page):1,1);
		$pagesize=15;
		$result=$datalist->getlist($this->product_table,$where,$orderby,$page,$pagesize);
		$this->pagestring=$datalist->pagestring;
		return $result;
	}

	function member_ypproductlist($userid=0,$status=-1,$starttime='',$endtime='',$k='')
	{
		global $page,$_siteid,$siteidobj;
		$userid=intval($userid);
		$where=$_siteid?'siteid IN('.implode(',',$siteidobj->getchildid($_siteid)).')':'1';
		$where.=$userid?' AND ypuserid='.$userid:'';
		$where.=$status>-1?' AND status='.$status:'';
		$where.=$starttime?' AND inputtime>=\''.trim($starttime).'\'':'';
		$where.=$endtime?' AND inputtime<=\''.(trim($endtime)+24*3600).'\'':'';
		$where.=$k?' AND title LIKE \'%'.$k.'%\'':'';

		include SYSTEM_ROOT.'include/datalist.class.php';
		$datalist = new datalist();
		$orderby='inputtime DESC';
		$page=max(isset($page)?intval($page):1,1);
		$pagesize=15;
		$result=$datalist->getlist($this->product_table,$where,$orderby,$page,$pagesize);
		$this->pagestring=$datalist->pagestring;
		return $result;
	}


	function product_setdelete($id,$userid)
	{
		$id=intval($id);
		$userid=intval($userid);
		return $this->db->query("DELETE FROM `$this->product_table` WHERE `$this->product_table`.`id`=$id AND  `$this->product_table`.`ypuserid`=$userid");
	}

	function product_refresh($id,$userid,$moduleid)
	{
		global $settings,$_gradeid,$_point,$_amount,$memberobj;

		$id=intval($id);
		$userid=intval($userid);
		$moduleid=intval($moduleid);
		
		return $this->db->query("UPDATE `$this->product_table` SET `$this->product_table`.`inputtime`=".TIME." WHERE `$this->product_table`.`id`=$id AND  `$this->product_table`.`ypuserid`=$userid");
	}

	function productinfo($productid)
	{	
		$productid=intval($productid);
		return $this->db->fetch_one("SELECT * FROM `$this->product_table` WHERE `$this->product_table`.`id`=$productid");
	}

	function member_product_add($info,$modelid=0,$extend=0)
	{
		global $modelobj,$settings,$dataobj,$cacheobj,$_userid,$_gradeid,$_point,$_amount,$conobj,$memberobj;
		$info['modelid']=intval($modelid);
		$modelinfo=$modelobj->info($modelid);

		$dataobj->setmodel(array(intval($modelid),intval($extend)));
		$info=$dataobj->filter($info);
		
		$info['clicks']=1;
		$info['siteid']=intval($_SESSION['siteid']);

		$hash_table=get_hash_table(LA_PRE.$modelinfo['tbname'].'_data',$info['mid'],$modelobj->subformcount(intval($extend)));

		$info['mid']=$this->db->insert(LA_PRE.$modelinfo['tbname'],$info,true);
		$this->db->insert($hash_table,$info,true);
		
		$cacheobj->clear();
		return true;
	}

	function member_product_edit($info,$modelid=0,$extend=0,$id)
	{
		global $modelobj,$settings,$dataobj,$cacheobj,$_userid,$_gradeid,$_point,$_amount,$conobj,$memberobj;
		$info['modelid']=intval($modelid);
		$id=intval($id);
		$modelinfo=$modelobj->info($modelid);

		$dataobj->setmodel(array(intval($modelid),intval($extend)));
		$info=$dataobj->filter($info);
		
		$info['inputtime']=TIME;

		$hash_table=get_hash_table(LA_PRE.$modelinfo['tbname'].'_data',$info['mid'],$modelobj->subformcount(intval($extend)));

		$this->db->update(LA_PRE.$modelinfo['tbname'],$info,'id='.$id);
		$this->db->update($hash_table,$info,'mid='.$id);
		
		$cacheobj->clear();
		return true;
	}

	function product_set($info,$ids=array())
	{
		global $settings,$_siteid,$siteidobj;

		$ids=is_array($ids)?array_map('intval',$ids):array(intval($ids));
		foreach($ids as $id)
		{
			if($id)
			{
				$cinfo=$this->productinfo($id);
				if(!$cinfo || ($_siteid && !in_array($cinfo['siteid'],$siteidobj->getchildid($_siteid))))
				{
					return false;
				}
				else
				{
					$this->db->update($this->product_table,$info,'id='.$id);
				}
			}
		}
		return true;
	}

	function product_delete($ids=array(),$userid=0)
	{
		global $settings,$_siteid,$siteidobj;

		$ids=is_array($ids)?array_map('intval',$ids):array(intval($ids));
		foreach($ids as $id)
		{
			if($id)
			{
				$cinfo=$this->productinfo($id);
				if(!$cinfo || ($_siteid && !in_array($cinfo['siteid'],$siteidobj->getchildid($_siteid))))
				{
					return false;
				}
				else
				{
					$coninfo=$this->getyp($cinfo['ypid']);
					if(!$userid || $userid==$coninfo['userid'])
					{
						$this->db->mysql_delete($this->product_table,$id,'id');
					}
				}
			}
		}

		return true;
	}

	function productstatis($ypid=0,$status=-1,$userid=0)
	{
		global $siteidobj,$_siteid;
		$ypid=intval($ypid);
		$status=intval($status);
		$userid=intval($userid);

		$where='1';
		$where.=$_siteid?' AND siteid IN('.implode(',',$siteidobj->getchildid($_siteid)).')':'';
		$where.=$status>=0?' AND status='.$status:'';
		$where.=$userid?' AND userid='.$userid:'';
		return get_cache_counts("SELECT COUNT(*) AS count FROM `$this->product_table` WHERE $where");
	}
	
	function formatypproducturl($id,$is_rewrite=1,$preview=0)
	{	
		global $moduleobj,$configobj,$urlcacheobj;

		$key='key-ypproduct-'.$id;
		$url=$urlcacheobj->get($key);
		
		if(!$url)
		{
			$id=intval($id);
			$modinfo=$moduleobj->get(16);
			$modsettings=$configobj->getconfig($_SESSION['siteid'],16);
			
			$minfo=$this->productinfo($id);
			
			$domain=$this->formatypdomain($minfo['ypid']);
			$url= $domain.'index.php?mod='.$modinfo['folder'].'&action=showproduct&productid='.intval($id).($preview?'&preview=1':'');
			$urlcacheobj->set($key,$url);
		}

		return $url;
		
	}

	function ypmingpianlist($userid=0,$status=-1,$starttime='',$endtime='',$k='')
	{
		global $page,$_siteid,$siteidobj;
		$userid=intval($userid);
		$where=$_siteid?'siteid IN('.implode(',',$siteidobj->getchildid($_siteid)).')':'1';
		$where.=$userid?' AND userid='.$userid:'';
		$where.=$status>-1?' AND status='.$status:'';
		$where.=$starttime?' AND inputtime>=\''.trim($starttime).'\'':'';
		$where.=$endtime?' AND inputtime<=\''.(trim($endtime)+24*3600).'\'':'';
		$where.=$k?' AND title LIKE \'%'.$k.'%\'':'';

		include SYSTEM_ROOT.'include/datalist.class.php';
		$datalist = new datalist();
		$orderby='id DESC';
		$page=max(isset($page)?intval($page):1,1);
		$pagesize=15;
		$result=$datalist->getlist($this->mingpian_table,$where,$orderby,$page,$pagesize);
		$this->pagestring=$datalist->pagestring;
		return $result;
	}

	function admin_mingpian_add($info,$modelid=0,$extend=0)
	{
		global $modelobj,$settings,$dataobj,$cacheobj,$memberobj;
		$info['modelid']=intval($modelid);
		$modelinfo=$modelobj->info($modelid);
	
		$dataobj->setmodel(array(intval($modelid),intval($extend)));
		$info=$dataobj->filter($info);

		$mem=$info;
		$mem['gradeid']=3;
		$mem['username']='company_'.TIME;
		$mem['password']=md5(mt_rand(100000,999999));
		$mem['email']='company_'.TIME.'@topmps.com';
		$mem['company']=$info['name'];
		$info['userid']=$memberobj->admin_companyadd($mem);

		$info['inputtime']=TIME;
		$info['status']=1;
		$info['siteid']=intval($_SESSION['siteid']);
		$info['mid']=$this->db->insert(LA_PRE.$modelinfo['tbname'],$info,true);
		$hash_table=get_hash_table(LA_PRE.$modelinfo['tbname'].'_data',$info['mid'],$modelobj->subformcount(intval($extend)));
		$cacheobj->clear();
		return $this->db->insert($hash_table,$info,true);
	}

	function admin_mingpian_edit($info,$id,$modelid=0,$extend=0)
	{
		global $modelobj,$settings,$dataobj,$cacheobj;
		$modelid=intval($modelid);
		$extend=intval($extend);
		$id=intval($id);
		
		$modelinfo=$modelobj->info($modelid);

		$dataobj->setmodel(array(intval($modelid),intval($extend)));
		$info=$dataobj->filter($info);

		$info['siteid']=intval($_SESSION['siteid']);
		$this->db->update($this->mingpian_table,$info,'id='.$id);
		$hash_table=get_hash_table(LA_PRE.$modelinfo['tbname'].'_data',$id,$modelobj->subformcount(intval($extend)));
		$cacheobj->clear();
		return $this->db->update($hash_table,$info,'mid='.$id);
	}

	function mingpianinfo($mingpianid)
	{	
		$mingpianid=intval($mingpianid);
		return $this->db->fetch_one("SELECT * FROM `$this->mingpian_table` WHERE `$this->mingpian_table`.`id`=$mingpianid");
	}

	function mingpian_set($info,$ids=array())
	{
		global $settings,$_siteid,$siteidobj;

		$ids=is_array($ids)?array_map('intval',$ids):array(intval($ids));
		foreach($ids as $id)
		{
			if($id)
			{
				$cinfo=$this->mingpianinfo($id);
				if(!$cinfo || ($_siteid && !in_array($cinfo['siteid'],$siteidobj->getchildid($_siteid))))
				{
					return false;
				}
				else
				{
					$this->db->update($this->mingpian_table,$info,'id='.$id);
				}
			}
		}
		return true;
	}

	function mingpian_delete($ids=array(),$userid=0)
	{
		global $settings,$_siteid,$siteidobj;

		$ids=is_array($ids)?array_map('intval',$ids):array(intval($ids));
		foreach($ids as $id)
		{
			if($id)
			{
				$cinfo=$this->mingpianinfo($id);
				if(!$cinfo || ($_siteid && !in_array($cinfo['siteid'],$siteidobj->getchildid($_siteid))))
				{
					return false;
				}
				else
				{
					$coninfo=$this->getyp($cinfo['ypid']);
					if(!$userid || $userid==$coninfo['userid'])
					{
						$this->db->mysql_delete($this->mingpian_table,$id,'id');
					}
				}
			}
		}

		return true;
	}

	function mingpianstatis($ypid=0,$status=-1,$userid=0)
	{
		global $siteidobj,$_siteid;
		$ypid=intval($ypid);
		$status=intval($status);
		$userid=intval($userid);

		$where='1';
		$where.=$_siteid?' AND siteid IN('.implode(',',$siteidobj->getchildid($_siteid)).')':'';
		$where.=$status>=0?' AND status='.$status:'';
		$where.=$userid?' AND userid='.$userid:'';
		return get_cache_counts("SELECT COUNT(*) AS count FROM `$this->mingpian_table` WHERE $where");
	}
	
	function formatypmingpianurl($id,$is_rewrite=1,$preview=0)
	{	
		global $moduleobj,$configobj,$urlcacheobj;

		$key='key-ypmingpian-'.$id;
		$url=$urlcacheobj->get($key);
		
		if(!$url)
		{
			$modinfo=$moduleobj->get(16);
			$modsettings=$configobj->getconfig($_SESSION['siteid'],16);
			
			if(preg_match('/http:\/\/(.+)/i',$modsettings['domain']))
			{
				if($modsettings['is_rewrite'] && $is_rewrite)
				{
					$url= $modsettings['domain'].'mingpian/show-'.intval($id).'.html';
				}
				else
				{
					$url= $modsettings['domain'].'mingpian/index.php?mod='.$modinfo['folder'].'&action=show&id='.intval($id).($preview?'&preview=1':'');
				}
				$url=formaturl($url);
			}
			else
			{
				if($modsettings['is_rewrite'] && $is_rewrite)
				{
					$url= LA_PATH.$modinfo['folder'].'/mingpian/show-'.intval($id).'.html';
				}
				else
				{
					$url= LA_PATH.$modinfo['folder'].'/mingpian/index.php?mod='.$modinfo['folder'].'&action=show&id='.intval($id).($preview?'&preview=1':'');
				}
			}
			$url=formaturl($url);
			$urlcacheobj->set($key,$url);
		}

		return $url;
			}
}
?>